%%%%%%%%%********* Do not* change anything in this file **********%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Time derivative by Backward Euler
% F(block1)=((dt)*A_cs-1)cs(t)+(dt)f_cs(cs(t))+cs(t-1)=0
% F(block2)=((dt)*A_ce-1)ce(t)+(dt)f_ce(cs(t))+ce(t-1)=0
% F(block3)=A_phie(ce)*[ce;phie]+f_phie
% F(block4)=A_phis*phis+f_phis+Biapp
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function F_cs=bat_F_cs(y_in)
global eta tem concS_o sv n_n n_s n_t n_p dt FARADAY RU ...
       diffuSolid_n diffuSolid_p R_s alpha_a alpha_c concS_max_n...
       concS_max_p kcon_n kcon_p A_csp A_csn A_cs jli
N_np=n_n+n_p;
nr=11;
dr=R_s/(nr-1);
T=tem(1);
conc=y_in(n_n+n_p+n_t+1:n_n+n_p+n_t+n_t);
concS=y_in((n_n+n_p)+n_t+n_t+1:(n_n+n_p)+n_t+n_t+nr*(n_n+n_p));
concS_surf=y_in((n_n+n_p)+n_t+n_t+nr*(n_n+n_p)+1:(n_n+n_p)+n_t+n_t+nr*(n_n+n_p)+n_t);
%% define BV equation
concS_max=zeros(1,n_t);concS_max(1:n_n)=concS_max_n;
concS_max(n_n+n_s+1:n_t)=concS_max_p;
kcon=zeros(1,n_t);kcon(1:n_n)=kcon_n;kcon(n_n+n_s+1:n_t)=kcon_p;
i0=kcon.*(conc.^alpha_a).*((concS_max-concS_surf).^alpha_a).*(concS_surf.^alpha_c);
exp1=exp((alpha_a * FARADAY/( RU * T ))* eta);
exp2= exp(-(alpha_c * FARADAY/( RU * T))* eta);
jli=sv.*i0.*(exp1-exp2);
    %% define F matrix for Concs
      i=1;
           %%%%%%%%%%%%%%% Negative %%%%%%%%%%%%%
           A_csn(i,i)=-2*diffuSolid_n/dr^2*dt-1;
           A_csn(i,i+1)=2*diffuSolid_n/dr^2*dt;
           %%%%%%%%%%%%%%% positive %%%%%%%%%%%%%
           A_csp(i,i)=-2*diffuSolid_p/dr^2*dt-1;
           A_csp(i,i+1)=2*diffuSolid_p/dr^2*dt;
    
           for i=2:nr-1

                %%%%%%%%%%%%%%% Negative %%%%%%%%%%%%%
                A_csn(i,i-1)=diffuSolid_n*(i-1)/(i)/dr^2*dt;
                A_csn(i,i)=-2*diffuSolid_n/dr^2*dt-1;
                A_csn(i,i+1)=diffuSolid_n*(i+1)/(i)/dr^2*dt;
                %%%%%%%%%%%%%%% positive %%%%%%%%%%%%%
                A_csp(i,i-1)=diffuSolid_p*(i-1)/(i)/dr^2*dt;
                A_csp(i,i)=-2*diffuSolid_p/dr^2*dt-1;
                A_csp(i,i+1)=diffuSolid_p*(i+1)/(i)/dr^2*dt;
            end
      i=nr;
                %%%%%%%%%%%%%%% Negative %%%%%%%%%%%%%
                A_csn(i,i-1)=2*diffuSolid_n/dr^2*dt;
                A_csn(i,i)=-2*diffuSolid_n/dr^2*dt-1;
                %%%%%%%%%%%%%%% positive %%%%%%%%%%%%%
                A_csp(i,i-1)=2*diffuSolid_p/dr^2*dt;
                A_csp(i,i)=-2*diffuSolid_p/dr^2*dt-1;
    for j=1:n_n
        A_cs((j-1)*nr+1:j*nr,(j-1)*nr+1:j*nr)=A_csn;
    end

    for j=n_n+1:n_n+n_p
        A_cs((j-1)*nr+1:j*nr,(j-1)*nr+1:j*nr)=A_csp;
    end
    f_cs(1:nr*N_np,1)=0;
    for i=1:n_n   
        f_cs(i*nr)=-2*(jli(i)/FARADAY/sv(i))*(1/R_s+1/dr)*dt;
    end
    for i=n_n+1:n_n+n_p
        f_cs(i*nr)=-2*(jli(i+n_s)/FARADAY/sv(i+n_s))*(1/R_s+1/dr)*dt;
    end

F_cs=A_cs*(concS')+f_cs+concS_o';




